import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class AlienDatabase {

	private ArrayList<ArrayList<Alien>> data;

	public AlienDatabase() {
		data = new ArrayList<ArrayList<Alien>>();
		for (int i = 0; i < 10; i++) {
			data.add(new ArrayList<Alien>());
		}
	}

	public void addAlien(Alien a) {
		ArrayList<Alien> row = data.get(a.getNumHeads() - 1);
		row.add(a);
		Collections.sort(row);
	}

	public void displayDatabase() {
		for (ArrayList<Alien> a : data) {
			for (Alien guy : a) {
				System.out.print(guy + "   ");
			}
			System.out.println();
		}
	}

	private static Random random = new Random();
	
	public static String makeRandomString() {
		StringBuffer answer = new StringBuffer();
		int length = random.nextInt(10) + 3;
		for (int i = 0; i < length; i++) {
			answer.append(getRandomCharacter());
		}
		return answer.toString();
	}
	

	private static char getRandomCharacter() {
		return (char)(random.nextInt(26) + 'A');
	}
	
	public static void main(String[] args) {
		// create and display a database full of random aliens
	
		AlienDatabase db = new AlienDatabase();
		
		for (int i = 0; i < 100; i++) {
			int numHeads = (int)(Math.random() * 10) + 1;
			String name = makeRandomString();
			db.addAlien(new Alien(numHeads, name));
		}
		db.displayDatabase();
	}
}
